/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.scoring;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;

public class Leaderboard {
    public static final String SCORE_FILE = "leaderboard.json";
    private Json json = new Json();
    private Array<ScoreEntry> scores = new Array();
    private static final Leaderboard instance = new Leaderboard();

    public static Leaderboard getInstance() {
        return instance;
    }

    public void saveScore(String playerName, int score) {
        FileHandle file = Gdx.files.local(SCORE_FILE);
        if (file.exists()) {
            String scoresJson = file.readString();
            this.scores = this.json.fromJson(Array.class, ScoreEntry.class, scoresJson);
        }
        this.scores.add(new ScoreEntry(playerName, score));
        this.scores.sort();
        if (this.scores.size > 10) {
            this.scores.truncate(10);
        }
        file.writeString(this.json.toJson(this.scores, Array.class, ScoreEntry.class), false);
    }

    public Array<ScoreEntry> getTopScores() {
        FileHandle file = Gdx.files.local(SCORE_FILE);
        if (file.exists()) {
            String scoresJson = file.readString();
            return this.json.fromJson(Array.class, ScoreEntry.class, scoresJson);
        }
        return new Array<ScoreEntry>();
    }

    public String returnFileName() {
        return SCORE_FILE;
    }

    public String getFormattedTopScores() {
        StringBuilder sb = new StringBuilder();
        Array<ScoreEntry> topScores = this.getTopScores();
        for (int i = 0; i < topScores.size; ++i) {
            sb.append(i + 1 + ". " + topScores.get((int)i).playerName + " : " + topScores.get((int)i).score + "\n");
        }
        return sb.toString();
    }

    public static class ScoreEntry
    implements Comparable<ScoreEntry> {
        public String playerName;
        public int score;

        public ScoreEntry() {
        }

        public ScoreEntry(String playerName, int score) {
            this.playerName = playerName;
            this.score = score;
        }

        @Override
        public int compareTo(ScoreEntry other) {
            return Integer.compare(other.score, this.score);
        }
    }
}

